<?php
/**
 * Initialize the custom Meta Boxes. 
 */
add_action( 'admin_init', 'custom_meta_boxes' );

/**
 * Meta Boxes By Reza Kianoosh From Tarlanweb.ir And Rkianoosh.ir.
 *
 * You can find all the available option types in demo-theme-options.php.
 *
 * @return    void
 * @since     2.0
 */
function custom_meta_boxes() {
  /**
   * Create a custom meta boxes array that we pass to 
   * the OptionTree Meta Box API Class.
   */


	
$kianoosh_box = array(
'id'=>'reza_kianoosh_box',
'title'=>'تنظیمات کلی محصول',
'desc'=>'برای نمایش قابلیتهای محصولات از زمینه های دلخواه این بخش استفاده کنید.',
'pages'=>array( 'download','post' ),
'context'=>'normal',
'priority'=>'high',
'fields'=>array(
array(
'id'=>'edd_id',
'label'=>'شناسه (id) محصول',
'desc'=>'شناسه یا همان id محصول را وارد کنید. این فیلد تنها برای وقتی که از بخش نوشته های وردپرس میخاهید محصول اضافه کنید کاربرد دارد.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'bt_buy',
'label'=>'باکس خرید',
'desc'=>'باکس خرید ثابت در انتهای صفحه نمایش داده شود ؟',
'std'=>'on',
'type'=>'on-off',
),
array(
'id'=>'demo_txtc',
'label'=>'پیش نمایش',
'desc'=>'عنوان لینک پیش نمایش را وارد کنید',
'std'=>'پیش نمایش آنلاین',
'type'=>'text',
),
array(
'id'=>'demo_urls',
'label'=>'لینک پیش نمایش',
'desc'=>'لینک پیش نمایش آنلاین را به همراه http:// وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'sh_titr',
'label'=>'عنوان دلخواه محصول',
'desc'=>'عنوان محصول قابل نمایش در منو ثابت پایین را وارد کنید. اگر خالی باشد عنوان کلی محصول نمایش داده میشود.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'update_times',
'label'=>'تاریخ بروزرسانی',
'desc'=>'تاریخ بروزرسانی محصول را با فرمت 20 دی 13400 وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'file_version',
'label'=>'نسخه فایل',
'desc'=>'نسخه فایل را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'file_sizes',
'label'=>'حجم فایل',
'desc'=>'حجم فایل را وارد کنید. مثال: 50 مگابایت',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'file_helps',
'label'=>'فایل راهنما',
'desc'=>'وجود فایل راهنما را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'file_instal',
'label'=>'بسته نصبی',
'desc'=>'وجود بسته نصبی را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'file_dl',
'label'=>'فایلهای قابل دانلود',
'desc'=>'فرمت فایلهای قابل دانلود را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'browsers_f',
'label'=>'مرورگرهای سازگار',
'desc'=>'لیست مرورگرهای سازگار را وارد کنید. مثال: Chrome, EDGE, Firefox, IE10, IE11, IE9, Opera, Safari',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'off_dates',
'label'=>'محصول ویژه',
'desc'=>'تاریخ پایان تخفیف ویژه را با فرمت 2021/12/30 وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'vip_imgs',
'label'=>'تصویر محصول',
'desc'=>'تصویر قابل نمایش در باکس معرفی محصول را با ابعاد 590 در 300 پیکسل وارد کنید.',
'std'=>'',
'type'=>'upload',
),
array(
'id'=>'vip_videos',
'label'=>'ویدیو محصول',
'desc'=>'ادرس ویدیو محصول برای نمایش در باکس معرفی محصول را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'pro_product1',
'label'=>'محصول حرفه ای',
'desc'=>'آیا محصول حرفه ای است ؟',
'std'=>'on',
'type'=>'on-off',
),
array(
'id'=>'irani_product1',
'label'=>'محصول ایرانی',
'desc'=>'آیا محصول ایرانی است ؟',
'std'=>'on',
'type'=>'on-off',
),
array(
'id'=>'ea_ins_product1',
'label'=>'بسته نصبی آسان',
'desc'=>'آیا محصول دارای بسته نصبی آسان است ؟',
'std'=>'on',
'type'=>'on-off',
),
array(
'id'=>'opt_ve_product1',
'label'=>'محصول اورجینال',
'desc'=>'آیا محصول اورجینال تائید شده است ؟',
'std'=>'on',
'type'=>'on-off',
),
array(
'id'=>'kigallery',
'label'=>'گالری تصاویر',
'desc'=>'گالری تصاویر را ایجاد کنید.',
'std'=>'',
'type'=>'gallery',
),
));
// courses
$kianoosh_box1 = array(
'id'=>'reza_kianoosh_box1',
'title'=>'تنظیمات دوره آموزشی',
'desc'=>'اگر مطلب دراره دوره آموزشی است این بخش را تکمیل کنید.',
'pages'=>array( 'download','post' ),
'context'=>'normal',
'priority'=>'high',
'fields'=>array(
array(
'id'=>'course_time',
'label'=>'مدت دوره',
'desc'=>'زمان کل دوره آموزشی را با فرمت 1:25:55 وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'course_video',
'label'=>'تعداد ویدیو',
'desc'=>'تعداد ویدیوهای دوره را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'co_lit',
'label'=>'دوره های آموزشی',
'desc'=>'لیست دوره های آموزشی را ایجاد کنید.',
'type'=>'list-item',
'settings'=>array(
array(
'id'=>'co_tme',
'label'=>'زمان',
'desc'=>'زمان این قسمت را برحسب دقیقه وارد کنید.',
'std'=>'',
'type'=>'text'
),
array(
'id'=>'co_fp',
'label'=>'نوع ویدیو',
'desc'=>'نوع ویدیو را مشخص کنید. رایگان یا غیر رایگان',
'std'=>'',
'type'=>'text'
),
array(
'id'=>'co_vid',
'label'=>'ویدیو',
'desc'=>'آدرس ویدیو این قسمت را وارد کنید. اگر رایگان است آدرس کامل ویدیو و اگر پولی است میتوانید دمو کوتاهی از این قسمت را وارد کنید یا خالی بگذارید.',
'std'=>'',
'type'=>'text'
),
array(
'id'=>'co_tt',
'label'=>'توضیحات',
'desc'=>'توضیحات این قسمت را وارد کنید. پیشنهاد: حتما حداقل 70 کلمه وارد کنید.',
'std'=>'',
'type'=>'textarea'
))),

));
// page
$kianoosh_box2 = array(
'id'=>'reza_kianoosh_box2',
'title'=>'سوالات متداول',
'desc'=>'لیست سوالات متداول را ایجاد کنید.',
'pages'=>array('page'),
'context'=>'normal',
'priority'=>'high',
'fields'=>array(
array(
'id'=>'qu_lit',
'label'=>'سوالات متداول',
'desc'=>'لیست سوالات متداول را ایجاد کنید.',
'type'=>'list-item',
'settings'=>array(
array(
'id'=>'qu_vid',
'label'=>'ویدیو',
'desc'=>'اگر قصد دارید از ویدیو استفاده کنید آدرس ویدئو را در این فیلم قرار دهید. در غیر اینصورت خالی بگذارید.',
'std'=>'',
'type'=>'text'
),
array(
'id'=>'qu_tt',
'label'=>'توضیحات',
'desc'=>'توضیحات این قسمت را وارد کنید. پیشنهاد: حتما حداقل 70 کلمه وارد کنید.',
'std'=>'',
'type'=>'textarea'
))),
));
// rom
$kianoosh_box3 = array(
'id'=>'reza_kianoosh_box3',
'title'=>'تنظیمات رام موبایل',
'desc'=>'اگر مطلب درباره رام موبایل است این بخش را تکمیل کنید.',
'pages'=>array( 'download','post' ),
'context'=>'normal',
'priority'=>'high',
'fields'=>array(
array(
'id'=>'rom_model',
'label'=>'مدل',
'desc'=>'مدل دستگاه را وارد کنید. مثال: xiaomi mi a3',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_android',
'label'=>'نسخه اندروید',
'desc'=>'نسخه اندروید را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_buildn',
'label'=>'بیلدنامبر',
'desc'=>'بیلدنامبر را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_csc',
'label'=>'نسخه csc',
'desc'=>'نسخه csc را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_region',
'label'=>'منطقه',
'desc'=>'منطقه را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_lang',
'label'=>'زبان',
'desc'=>'زبان رام را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_files',
'label'=>'تعداد فایل',
'desc'=>'تعداد فایل را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_type',
'label'=>'نوع رام',
'desc'=>'نوع رام را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'rom_wright',
'label'=>'قابلیت رایت',
'desc'=>'قابلیت رایت را وارد کنید. نکته: نام نرم افزاری که امکان رایت با آن وجود دارد را وارد کنید.',
'std'=>'',
'type'=>'text',
),

));
// book
$kianoosh_box4 = array(
'id'=>'reza_kianoosh_box4',
'title'=>'تنظیمات کتاب و مقاله',
'desc'=>'اگر مطلب درباره کتاب و مقاله است این بخش را تکمیل کنید.',
'pages'=>array( 'download','post' ),
'context'=>'normal',
'priority'=>'high',
'fields'=>array(
array(
'id'=>'book_auth',
'label'=>'نویسنده',
'desc'=>'نام نویسنده را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_trans',
'label'=>'مترجم',
'desc'=>'نام مترجم را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_nasher',
'label'=>'ناشر',
'desc'=>'نام ناشر را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_shabek',
'label'=>'شابک',
'desc'=>'کد شابک را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_ghat',
'label'=>'قطع',
'desc'=>'نوع قطع را وارد کنید. مثال: رقعی',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_year',
'label'=>'سال انتشار',
'desc'=>'سال انتشار را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_pages',
'label'=>'تعداد صفحات',
'desc'=>'تعداد صفحات را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_lang',
'label'=>'زبان',
'desc'=>'زبان کتاب را وارد کنید.',
'std'=>'',
'type'=>'text',
),
array(
'id'=>'book_format',
'label'=>'فرمت',
'desc'=>'فرمت کتاب را وارد کنید.',
'std'=>'',
'type'=>'text',
),

));
/**
   * Register our meta boxes using the 
   * ot_register_meta_box() function.
   */
  if ( function_exists( 'ot_register_meta_box' ) )
    ot_register_meta_box( $kianoosh_box );
    ot_register_meta_box( $kianoosh_box1 );
    ot_register_meta_box( $kianoosh_box2 );
    ot_register_meta_box( $kianoosh_box3 );
    ot_register_meta_box( $kianoosh_box4 );
}